# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from enum import Enum
from ..sdpackage import SDPackage
from ..sdapiobject import SDAPIObject
from ..sdapiobject import SDApiError
from ..apiexception import APIException

class SDCompressionMode(Enum):
    """
    Enum representing the compression mode of the data in the sbsar
    """
    """Automatic mode depending of the data type"""
    Auto = 0
    """Slow encode/decode"""
    Best = 1
    """Fast encode/decode"""
    NoCompression = 2

class SDSBSARExporter(SDAPIObject):
    """
    Utility to export SBS Package
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDSBSARExporter
        """
        super(SDSBSARExporter, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew() -> SDSBSARExporter:
        """
        Create a new SDSBSARExporter instance

        """
        outSDSBSARExporter = ctypes.c_void_p()
        _res = sd.getContext().SDSBSARExporter_sNew(ctypes.byref(outSDSBSARExporter))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDSBSARExporter, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDSBSARExporter.value, ownHandle=True)

    def setIconEnabled(self, value : bool) -> None:
        """
        Specify if the icon is in the sbsar

        :param value: The value that indicates if the icon has to be in the sbsar
        """
        _res = self.mAPIContext.SDSBSARExporter_setIconEnabled(self.mHandle, value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setExposeOutputSize(self, value : bool) -> None:
        """
        Specify if the "outputsize" parameter is exposed in the sbsar

        :param value: The value that indicates if the "outputsize" parameter is exposed in the sbsar
        """
        _res = self.mAPIContext.SDSBSARExporter_setExposeOutputSize(self.mHandle, value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setExposePixelSize(self, value : bool) -> None:
        """
        Specify if the "pixelsize" parameter is exposed in the sbsar

        :param value: The value that indicates if the "pixelsize" parameter is exposed in the sbsar
        """
        _res = self.mAPIContext.SDSBSARExporter_setExposePixelSize(self.mHandle, value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setExposeRandomSeed(self, value : bool) -> None:
        """
        Specify if the "randomseed" parameter is exposed in the sbsar

        :param value: The value that indicates if the "randomseed" parameter is exposed in the sbsar
        """
        _res = self.mAPIContext.SDSBSARExporter_setExposeRandomSeed(self.mHandle, value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setCompressionMode(self, sdCompressionMode : SDCompressionMode) -> None:
        """
        Specify the data compression mode (See SDCompressionMode enum)

        :param sdCompressionMode: The value that indicates if the the data compression mode (See SDCompressionMode enum)
        """
        _res = self.mAPIContext.SDSBSARExporter_setCompressionMode(self.mHandle, sdCompressionMode.value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def exportPackageToSBSAR(self, sdPackage : SDPackage, sbsarOutputFilePath : str) -> None:
        """
        Export the specified SDPackage to the specified .sbsar file. The specified package will be automatically saved. If the package has not been saved already, the operation will fail

        :param sdPackage: The SDPackage to export.
        :param sbsarOutputFilePath: The file path of the .sbsar file that will be generated
        """
        _res = self.mAPIContext.SDSBSARExporter_exportPackageToSBSAR(self.mHandle, sdPackage.mHandle, ctypes.create_string_buffer(sbsarOutputFilePath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def exportSBSFileToSBSAR(self, sbsFilePath : str, sbsarOutputFilePath : str) -> None:
        """
        Export the specified .sbs file to the specified .sbsar file.

        :param sbsFilePath: The filepath to the .sbs package to export.
        :param sbsarOutputFilePath: The file path of the .sbsar file that will be generated
        """
        _res = self.mAPIContext.SDSBSARExporter_exportSBSFileToSBSAR(self.mHandle, ctypes.create_string_buffer(sbsFilePath.encode('utf-8')), ctypes.create_string_buffer(sbsarOutputFilePath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

